import { query } from './database.js';

export const ModuleModel = {
    async getAll() {
        const res = await query('SELECT *, id_module as id FROM modules');
        return res.rows;
    },

    async getByCompanyId(institutionId) {
        const res = await query(
            `SELECT m.*, m.id_module as id, im.is_enabled
       FROM modules m
       LEFT JOIN institution_modules im ON m.id_module = im.module_id AND im.institution_id = $1
       ORDER BY m.id_module`,
            [institutionId]
        );
        return res.rows;
    },

    async toggleModule(institutionId, moduleId, isEnabled) {
        const res = await query(
            `INSERT INTO institution_modules (institution_id, module_id, is_enabled)
       VALUES ($1, $2, $3)
       ON CONFLICT (institution_id, module_id)
       DO UPDATE SET is_enabled = $3
       RETURNING *`,
            [institutionId, moduleId, isEnabled]
        );
        return res.rows[0];
    }
};
