import { query } from './database.js';

export const OrderModel = {
    async getAll() {
        const res = await query(`
            SELECT cs.*, e.name as employee_name, e.photo_url as employee_photo_url 
            FROM contracted_services cs
            LEFT JOIN employees e ON cs.employee_id = e.id
        `);
        return res.rows;
    },

    async getById(id) {
        const res = await query(`
            SELECT cs.*, e.name as employee_name, e.photo_url as employee_photo_url 
            FROM contracted_services cs
            LEFT JOIN employees e ON cs.employee_id = e.id
            WHERE cs.id = $1
        `, [id]);
        return res.rows[0];
    },

    async getByCompanyId(companyId) {
        const res = await query(`
            SELECT cs.*, e.name as employee_name, e.photo_url as employee_photo_url 
            FROM contracted_services cs
            LEFT JOIN employees e ON cs.employee_id = e.id
            WHERE cs.company_id = $1
        `, [companyId]);
        return res.rows;
    },

    async getByClientId(clientId) {
        const res = await query(`
            SELECT cs.*, e.name as employee_name, e.photo_url as employee_photo_url 
            FROM contracted_services cs
            LEFT JOIN employees e ON cs.employee_id = e.id
            WHERE cs.client_id = $1
        `, [clientId]);
        return res.rows;
    },

    async getByEmployeeId(employeeId) {
        const res = await query(`
            SELECT cs.*, e.name as employee_name, e.photo_url as employee_photo_url 
            FROM contracted_services cs
            LEFT JOIN employees e ON cs.employee_id = e.id
            WHERE cs.employee_id = $1
        `, [employeeId]);
        return res.rows;
    },

    async create(order) {
        const { company_id, client_id, service_catalogo_id, employee_id, service_number, service_address, request_date, deadline_date, closed_at, warranty_end_date, status, employee_report, client_rating, client_comment, finalized_by_client, payment_reference, payment_status, payment_proof_url } = order;
        const res = await query(
            `INSERT INTO contracted_services (company_id, client_id, service_catalogo_id, employee_id, service_number, service_address, request_date, deadline_date, closed_at, warranty_end_date, status, employee_report, client_rating, client_comment, finalized_by_client, payment_reference, payment_status, payment_proof_url)
       VALUES ($1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13, $14, $15, $16, $17, $18)
       RETURNING *`,
            [company_id, client_id, service_catalogo_id, employee_id, service_number, service_address, request_date, deadline_date, closed_at, warranty_end_date, status, employee_report, client_rating, client_comment, finalized_by_client, payment_reference, payment_status, payment_proof_url]
        );
        return res.rows[0];
    },

    async update(id, order) {
        const fields = [];
        const values = [];
        let idx = 1;

        // Añadir lógica para fechas automáticas según el estado
        if (order.status === 'FINISHED' && !order.end_date) {
            order.end_date = 'CURRENT_TIMESTAMP';
        }
        if (order.status === 'CLOSED' && !order.closed_at) {
            order.closed_at = 'CURRENT_TIMESTAMP';
        }

        for (const [key, value] of Object.entries(order)) {
            // Excluir campos que no deben ser actualizados directamente o son joins
            if (key !== 'updated_at' && key !== 'created_at' && key !== 'id' && key !== 'employee_name' && key !== 'employee_photo_url') {
                // Manejar valores de fecha especiales
                if (value === 'CURRENT_TIMESTAMP') {
                    fields.push(`${key} = CURRENT_TIMESTAMP`);
                } else {
                    fields.push(`${key} = $${idx}`);
                    values.push(value);
                    idx++;
                }
            }
        }

        if (fields.length === 0) {
            return this.getById(id);
        }

        values.push(id);

        const res = await query(
            `UPDATE contracted_services SET ${fields.join(', ')}, updated_at = CURRENT_TIMESTAMP WHERE id = $${idx} RETURNING *`,
            values
        );
        return res.rows[0];
    },

    async delete(id) {
        await query('DELETE FROM contracted_services WHERE id = $1', [id]);
        return true;
    }
};
