import { query } from './database.js';

export const ServiceModel = {
    async getAll() {
        const res = await query('SELECT * FROM services_catalogo');
        return res.rows;
    },

    async getById(id) {
        const res = await query('SELECT * FROM services_catalogo WHERE id = $1', [id]);
        return res.rows[0];
    },

    async getByCompanyId(companyId) {
        const res = await query('SELECT * FROM services_catalogo WHERE company_id = $1', [companyId]);
        return res.rows;
    },

    async create(service) {
        const { company_id, name, description, category, max_time_hours, has_warranty, warranty_months, warranty_exceptions, is_active } = service;
        const res = await query(
            `INSERT INTO services_catalogo (company_id, name, description, category, max_time_hours, has_warranty, warranty_months, warranty_exceptions, is_active)
       VALUES ($1, $2, $3, $4, $5, $6, $7, $8, $9)
       RETURNING *`,
            [company_id, name, description, category, max_time_hours, has_warranty, warranty_months, warranty_exceptions, is_active]
        );
        return res.rows[0];
    },

    async update(id, service) {
        const fields = [];
        const values = [];
        let idx = 1;

        for (const [key, value] of Object.entries(service)) {
            if (key !== 'updated_at' && key !== 'created_at' && key !== 'id') {
                fields.push(`${key} = $${idx}`);
                values.push(value);
                idx++;
            }
        }
        values.push(id);

        const res = await query(
            `UPDATE services_catalogo SET ${fields.join(', ')}, updated_at = CURRENT_TIMESTAMP WHERE id = $${idx} RETURNING *`,
            values
        );
        return res.rows[0];
    },

    async delete(id) {
        await query('DELETE FROM services_catalogo WHERE id = $1', [id]);
        return true;
    }
};
