import { query } from './database.js';

export const SystemConfigModel = {
    async getAll() {
        const res = await query('SELECT * FROM system_config');
        return res.rows;
    },

    async getByKey(key) {
        const res = await query('SELECT * FROM system_config WHERE config_key = $1', [key]);
        return res.rows[0];
    },

    async set(key, value, description) {
        const res = await query(
            `INSERT INTO system_config (config_key, config_value, description)
       VALUES ($1, $2, $3)
       ON CONFLICT (config_key)
       DO UPDATE SET config_value = $2, description = $3, updated_at = CURRENT_TIMESTAMP
       RETURNING *`,
            [key, value, description]
        );
        return res.rows[0];
    }
};
