import { useState, useEffect } from 'react';
import { Outlet } from 'react-router-dom';
import Layout from '../../components/Layout';
import { adminLinks } from './adminLinks';
import { getModulesByCompany } from '../../services/api';

const AdminLayout = () => {
  const user = JSON.parse(sessionStorage.getItem('user') || '{}');
  const [filteredLinks, setFilteredLinks] = useState([]);

  useEffect(() => {
    const fetchModules = async () => {
      const institutionId = user.institution_id || user.company_id;
      if (!institutionId) {
        setFilteredLinks(adminLinks); // Fallback si no hay ID
        return;
      }

      try {
        const modules = await getModulesByCompany(institutionId);

        // Mapeo de nombres de módulos a nombres de enlaces
        const moduleMap = {
          'Gestión de Estudiantes': 'Estudiantes',
          'Banco de Preguntas': 'Banco de Preguntas',
          'Gestión de Profesores': 'Profesores',
          'Exámenes': 'Exámenes',
          'Reportes': 'Reportes'
        };

        const enabledModuleNames = modules
          .filter(m => m.is_enabled)
          .map(m => moduleMap[m.name]);

        const newLinks = adminLinks.filter(link => {
          // Dashboard, Gestión de Estudiantes, Gestión de Profesores, Exámenes y Configuración siempre visibles
          if (
            link.nombre === 'Dashboard' || 
            link.nombre === 'Gestión de Estudiantes' || 
            link.nombre === 'Gestión de Profesores' || 
            link.nombre === 'Especialidades' ||
            link.nombre === 'Exámenes' || 
            link.nombre === 'Configuración'
          ) return true;
          
          // Los demás dependen de si su módulo está habilitado
          return enabledModuleNames.includes(link.nombre);
        });

        setFilteredLinks(newLinks);
      } catch (error) {
        console.error('Error fetching modules:', error);
        setFilteredLinks(adminLinks); // Fallback en caso de error
      }
    };

    fetchModules();
  }, [user.institution_id, user.company_id]);

  return (
    <Layout
      links={filteredLinks.length > 0 ? filteredLinks : adminLinks}
      userType="ADMIN"
      userName={user.email || 'Administrador'}
      userPhoto="https://ui-avatars.com/api/?name=Admin+User&background=0D8ABC&color=fff"
    >
      <Outlet />
    </Layout>
  );
};

export default AdminLayout;
