import {
  Box,
  Heading,
  VStack,
  Text,
  Card,
  CardBody,
  Badge
} from '@chakra-ui/react';
import Layout from '../../components/Layout';
import { mockMetas, mockAlumnos } from '../../data/mockData';

const padreLinks = [
  { nombre: 'Avance (Bitácoras)', path: '/padre/bitacoras' },
  { nombre: 'Metas', path: '/padre/metas' },
  { nombre: 'Pagos', path: '/padre/pagos' },
  { nombre: 'Calendario', path: '/padre/calendario' },
  { nombre: 'Notificaciones', path: '/padre/notificaciones' }
];

const padreId = 1;
const misHijos = mockAlumnos.filter(a => a.id_padre === padreId);

const ConsultaMetasHijo = () => {
  return (
    <Layout links={padreLinks} userType="Padre/Tutor" userName="Roberto López">
      <Box>
        <Heading size="lg" mb={4} color="brand.500">Metas de Mis Hijos</Heading>

        {/* Instrucciones minimalistas */}
        <Text fontSize="sm" color="gray.600" mb={6}>
          Revisa las metas establecidas para tus hijos. <strong>Estas metas guían el progreso</strong> durante el curso.
        </Text>
        
        <VStack align="stretch" spacing={4}>
          {misHijos.map((hijo) => (
            <Card key={hijo.id}>
              <CardBody>
                <VStack align="stretch" spacing={3}>
                  <Box>
                    <Badge colorScheme="brand" mb={2}>{hijo.nombre}</Badge>
                    <Text fontSize="sm" color="gray.600">
                      Edad: {hijo.edad} años
                    </Text>
                  </Box>
                  <Box>
                    <Text fontWeight="bold" mb={2}>Metas y Objetivos:</Text>
                    <Text color="gray.700" whiteSpace="pre-wrap">
                      {mockMetas[hijo.id] || 'No se han establecido metas aún para este alumno.'}
                    </Text>
                  </Box>
                </VStack>
              </CardBody>
            </Card>
          ))}
        </VStack>
      </Box>
    </Layout>
  );
};

export default ConsultaMetasHijo;

