import {
  Box,
  Text
} from '@chakra-ui/react';
import Layout from '../../components/Layout';
import Calendar from '../../components/Calendar';
import { mockClases, mockAlumnos, mockMaterias, mockProfesores, mockBitacoras } from '../../data/mockData';

const profesorLinks = [
  { nombre: 'Dashboard', path: '/profesor' },
  { nombre: 'Mis Alumnos', path: '/profesor/alumnos' },
  { nombre: 'Registrar Bitácora', path: '/profesor/bitacora' },
  { nombre: 'Mi Calendario', path: '/profesor/calendario' },
  { nombre: 'Notificaciones', path: '/profesor/notificaciones' }
];

const profesorId = 1;
const misClases = mockClases.filter(c => c.id_profesor === profesorId);

const CalendarioProfesor = () => {
  // Enriquecer las clases con información completa
  const clasesEnriquecidas = misClases.map(clase => ({
    ...clase,
    profesor: mockProfesores.find(p => p.id === clase.id_profesor),
    alumno: mockAlumnos.find(a => a.id === clase.id_alumno),
    materia: mockMaterias.find(m => m.id === clase.id_materia)
  }));

  // Filtrar bitácoras del profesor
  const misBitacoras = mockBitacoras.filter(b => b.id_profesor === profesorId);

  return (
    <Layout links={profesorLinks} userType="Profesor" userName="María González">
      <Box mb={4}>
        <Text fontSize="sm" color="gray.600" mb={6}>
          Visualiza tus clases programadas. <strong>El calendario muestra tus horarios</strong> y las bitácoras registradas.
        </Text>
      </Box>
      <Calendar 
        clases={clasesEnriquecidas} 
        bitacoras={misBitacoras}
        alumnos={mockAlumnos}
        userType="profesor" 
      />
    </Layout>
  );
};

export default CalendarioProfesor;

