import { Outlet } from 'react-router-dom';
import Layout from '../../components/Layout';
import { professorLinks } from './professorLinks';

const ProfessorLayout = () => {
    const user = JSON.parse(sessionStorage.getItem('user') || '{}');

    return (
        <Layout
            links={professorLinks}
            userType="PROFESSOR"
            userName={user.email || 'Profesor'}
            userPhoto="https://ui-avatars.com/api/?name=Professor+User&background=6366F1&color=fff"
        >
            <Outlet />
        </Layout>
    );
};

export default ProfessorLayout;
