import { Outlet } from 'react-router-dom';
import Layout from '../../components/Layout';
import { studentLinks } from './studentLinks';

const StudentLayout = () => {
    const user = JSON.parse(sessionStorage.getItem('user') || '{}');

    return (
        <Layout
            links={studentLinks}
            userType="ESTUDIANTE"
            userName={user.name || 'Estudiante'}
            userPhoto="https://ui-avatars.com/api/?name=Student+User&background=4F46E5&color=fff"
        >
            <Outlet />
        </Layout>
    );
};

export default StudentLayout;
