import { extendTheme } from '@chakra-ui/react';

const theme = extendTheme({
  colors: {
    brand: {
      50: '#EEF2FF',
      100: '#E0E7FF',
      200: '#C7D2FE',
      300: '#A5B4FC',
      400: '#818CF8',
      500: '#6366F1', // Indigo 500
      600: '#4F46E5', // Indigo 600
      700: '#4338CA',
      800: '#3730A3',
      900: '#312E81',
    },
    accent: {
      yellow: '#FEF3C7',
      blue: '#DBEAFE',
      green: '#D1FAE5',
      pink: '#FCE7F3',
      orange: '#FED7AA',
      purple: '#E9D5FF',
      indigo: '#E0E7FF',
    },
    gray: {
      50: '#F9FAFB',
      100: '#F3F4F6',
      200: '#E5E7EB',
      300: '#D1D5DB',
      400: '#9CA3AF',
      500: '#6B7280',
      600: '#4B5563',
      700: '#374151',
      800: '#1F2937',
      900: '#111827',
    },
    sidebar: {
      bg: '#1E293B',
      active: '#0EA5E9',
      text: '#F1F5F9',
      textInactive: '#94A3B8',
      border: '#334155',
      hover: '#334155',
    }
  },
  fonts: {
    heading: `'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif`,
    body: `'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif`,
  },
  components: {
    Button: {
      baseStyle: {
        fontWeight: '500',
        borderRadius: '8px',
        transition: 'all 0.2s ease-in-out',
        _hover: {
          transform: 'translateY(-1px)',
          boxShadow: '0 4px 12px rgba(0, 0, 0, 0.15)',
        },
        _active: {
          transform: 'translateY(0)',
        },
      },
      variants: {
        solid: {
          boxShadow: '0 1px 3px rgba(0, 0, 0, 0.12), 0 1px 2px rgba(0, 0, 0, 0.24)',
          _hover: {
            boxShadow: '0 4px 12px rgba(0, 0, 0, 0.15)',
          },
        },
      },
      defaultProps: {
        colorScheme: 'brand',
      },
    },
    Card: {
      baseStyle: {
        container: {
          borderRadius: '12px',
          border: '1px solid',
          borderColor: 'gray.200',
          bg: 'white',
          boxShadow: '0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06)',
          transition: 'all 0.2s ease-in-out',
          _hover: {
            boxShadow: '0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06)',
          },
        },
      },
    },
    Input: {
      baseStyle: {
        field: {
          borderRadius: '8px',
          borderColor: 'gray.300',
          transition: 'all 0.2s ease-in-out',
          _focus: {
            borderColor: 'brand.500',
            boxShadow: '0 0 0 3px rgba(14, 165, 233, 0.1)',
          },
          _hover: {
            borderColor: 'gray.400',
          },
        },
      },
    },
    Select: {
      baseStyle: {
        field: {
          borderRadius: '8px',
          borderColor: 'gray.300',
          transition: 'all 0.2s ease-in-out',
          _focus: {
            borderColor: 'brand.500',
            boxShadow: '0 0 0 3px rgba(14, 165, 233, 0.1)',
          },
          _hover: {
            borderColor: 'gray.400',
          },
        },
      },
    },
    Textarea: {
      baseStyle: {
        borderRadius: '8px',
        borderColor: 'gray.300',
        transition: 'all 0.2s ease-in-out',
        _focus: {
          borderColor: 'brand.500',
          boxShadow: '0 0 0 3px rgba(14, 165, 233, 0.1)',
        },
        _hover: {
          borderColor: 'gray.400',
        },
      },
    },
    Modal: {
      baseStyle: {
        overlay: {
          bg: 'blackAlpha.600',
          backdropFilter: 'blur(4px)',
        },
        dialog: {
          borderRadius: '16px',
          boxShadow: '0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04)',
          border: '1px solid',
          borderColor: 'gray.200',
          maxW: '5xl', // Ancho mayor por defecto para evitar modales muy largos verticalmente
        },
        header: {
          borderBottom: '1px solid',
          borderColor: 'gray.200',
          pb: 3,
          fontWeight: '700',
          fontSize: '18px',
        },
        footer: {
          borderTop: '1px solid',
          borderColor: 'gray.200',
          pt: 4,
        },
      },
    },
    Table: {
      baseStyle: {
        th: {
          fontWeight: '600',
          textTransform: 'uppercase',
          fontSize: '11px',
          letterSpacing: '0.5px',
          color: 'gray.500',
          borderColor: 'gray.200',
          bg: 'gray.50',
        },
        td: {
          borderColor: 'gray.200',
          fontSize: '14px',
        },
        tr: {
          transition: 'all 0.2s ease-in-out',
          _hover: {
            bg: 'gray.50',
          },
        },
      },
    },
    Badge: {
      baseStyle: {
        borderRadius: '6px',
        px: 2,
        py: 1,
        fontWeight: '500',
        fontSize: '12px',
      },
    },
  },
  styles: {
    global: {
      body: {
        bg: '#F8FAFC', // Slate 50 is #F8FAFC
        color: 'gray.900',
        fontFamily: 'Inter, sans-serif',
      },
      '*::placeholder': {
        color: 'gray.400',
      },
    },
  },
  config: {
    initialColorMode: 'light',
    useSystemColorMode: false,
  },
});

export default theme;

