# Test Plan for Keservicios System

## Overview
This document outlines the functional test strategy for the Keservicios system, covering all user profiles and key workflows.

## Profiles & Test Scope

### 1. ADMIN Profile
**User**: `admin@serviciosnorte.com` (Company ID: 1)
**Scenarios**:
- [ ] Login successfully.
- [ ] Create a new Client.
- [ ] Update Client details (including new fields: email, is_active, fiscal_address).
- [ ] Create a new Employee.
- [ ] Create a new Service Order.
- [ ] Assign Service Order to Employee.
- [ ] View list of Orders.

### 2. EMPLOYEE Profile
**User**: `juan.perez@serviciosnorte.com` (Company ID: 1)
**Scenarios**:
- [ ] Login successfully.
- [ ] View assigned Orders.
- [ ] Update Order status (e.g., to IN_PROGRESS).
- [ ] Add Evidence (simulated) to an Order.

### 3. CLIENT Profile
**User**: `roberto.martinez@email.com` (Company ID: 1)
**Scenarios**:
- [ ] Login successfully (using email).
- [ ] View own Service History.
- [ ] Verify "Access without Service" logic (if applicable via API response).

### 4. ROOT Profile
**User**: `root@kesoftware.com`
**Scenarios**:
- [ ] Login successfully.
- [ ] List all companies / System wide check (if endpoints exist).

## Execution Strategy
- Automated script `test/run_functional_tests.js` using Node.js.
- Helper `test/api_client.js` to manage authentication and state.
- Output results to `test/results/test_execution.log`.
- Summary of failures in `test/results/incidences.md`.
