// test/connection.test.js
// Simple script to test PostgreSQL connection for the Keservicios project
// Run with: node test/connection.test.js

const { Client } = require('pg');
const fs = require('fs');
const path = require('path');

// Connection configuration – adjust as needed for your environment
const config = {
    user: process.env.PGUSER || 'postgres',
    host: process.env.PGHOST || 'localhost',
    database: process.env.PGDATABASE || 'keservicios',
    password: process.env.PGPASSWORD || '',
    port: process.env.PGPORT ? parseInt(process.env.PGPORT) : 5432,
};

const client = new Client(config);

(async () => {
    try {
        await client.connect();
        console.log('✅ Conexión a PostgreSQL exitosa');
        const res = await client.query('SELECT version();');
        console.log('Versión de PostgreSQL:', res.rows[0].version);
        // Guardar evidencia de éxito
        const evidencePath = path.join(__dirname, 'evidence', 'connection_success.txt');
        fs.mkdirSync(path.dirname(evidencePath), { recursive: true });
        fs.writeFileSync(evidencePath, `Conexión exitosa\nVersión: ${res.rows[0].version}\nTimestamp: ${new Date().toISOString()}`);
    } catch (err) {
        console.error('❌ Error al conectar a PostgreSQL:', err.message);
        // Guardar evidencia de error
        const evidencePath = path.join(__dirname, 'evidence', 'connection_error.txt');
        fs.mkdirSync(path.dirname(evidencePath), { recursive: true });
        fs.writeFileSync(evidencePath, `Error de conexión: ${err.message}\nTimestamp: ${new Date().toISOString()}`);
        process.exit(1);
    } finally {
        await client.end();
    }
})();
