
import fetch from 'node-fetch';
import bcrypt from 'bcryptjs';
import pool from '../src/models/database.js';

async function debugLogin() {
    console.log('--- DEBUG LOGIN ---');
    const email = 'admin@serviciosnorte.com';
    const password = 'demo123';

    // 1. Check DB directly
    const res = await pool.query('SELECT * FROM users WHERE email = $1', [email]);
    const user = res.rows[0];

    if (!user) {
        console.error('❌ User not found in DB');
        process.exit(1);
    }
    console.log('✅ User found in DB:', user.email);
    console.log('   Hash in DB:', user.password_hash);

    // 2. Test bcrypt locally
    const match = await bcrypt.compare(password, user.password_hash);
    console.log('   BCrypt Compare (Local):', match);

    // 3. Test API
    try {
        const response = await fetch('http://localhost:8081/api/auth/login', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ email, password })
        });

        console.log(`   API Response Status: ${response.status}`);
        const text = await response.text();
        console.log(`   API Response Body: ${text}`);

    } catch (e) {
        console.error('   API Request failed:', e.message);
    }

    await pool.end();
}

debugLogin();
