
import pool from '../src/models/database.js';

async function listUsers() {
    try {
        const res = await pool.query('SELECT id, email, role, is_active FROM users');
        console.log('--- USERS IN DB ---');
        console.table(res.rows);
    } catch (err) {
        console.error('Error listing users:', err);
    } finally {
        await pool.end();
    }
}

listUsers();
