import bcrypt from 'bcryptjs';
import pool from '../src/models/database.js';

async function updatePasswords() {
    try {
        const salt = await bcrypt.genSalt(10);
        const hash = await bcrypt.hash('demo123', salt);

        console.log('Generated hash for "demo123":', hash);

        // Update Admin
        await pool.query('UPDATE users SET password_hash = $1 WHERE email = $2', [hash, 'admin@miempresa.com']);
        // Update Employee
        await pool.query('UPDATE users SET password_hash = $1 WHERE email = $2', [hash, 'empleado@miempresa.com']);
        // Update Client
        await pool.query('UPDATE users SET password_hash = $1 WHERE email = $2', [hash, 'edna@gmail.com']);
        // Update Root
        await pool.query('UPDATE users SET password_hash = $1 WHERE email = $2', [hash, 'hola@kemarketing.mx']);

        console.log('✅ Passwords updated to "demo123" for test accounts.');
    } catch (err) {
        console.error('❌ Failed to update passwords:', err);
    } finally {
        await pool.end();
    }
}

updatePasswords();
