import fs from 'fs';
import pool from '../src/models/database.js';

async function runMigration() {
    try {
        const sql = fs.readFileSync('../sql/add_email_column.sql', 'utf8');
        console.log('Applying migration...');
        await pool.query(sql);
        console.log('✅ Migration successful: email column added/verified.');
    } catch (err) {
        console.error('❌ Migration failed:', err);
    } finally {
        await pool.end();
    }
}

runMigration();
