import pg from 'pg';
import fs from 'fs';
import path from 'path';
import { fileURLToPath } from 'url';

const { Pool } = pg;
const __dirname = path.dirname(fileURLToPath(import.meta.url));

const pool = new Pool({
    host: '172.16.168.128',
    port: 5432,
    user: 'iger',
    password: 'amalia.12',
    database: 'keservicios',
});

async function runMigration(filePath) {
    const client = await pool.connect();
    try {
        const sql = fs.readFileSync(path.join(__dirname, filePath), 'utf8');
        console.log(`Running migration: ${filePath}`);
        await client.query('BEGIN');
        await client.query(sql);
        await client.query('COMMIT');
        console.log('Migration completed successfully');
    } catch (error) {
        await client.query('ROLLBACK');
        console.error('Error running migration:', error);
        process.exit(1);
    } finally {
        client.release();
        await pool.end();
    }
}

const args = process.argv.slice(2);
if (args.length === 0) {
    console.error('Usage: node run_migration.js <sql_file>');
    process.exit(1);
}

runMigration(args[0]);
