import pg from 'pg';
const { Pool } = pg;

// Try different local configurations
const configs = [
    { host: 'localhost', port: 5432, user: 'iger', database: 'keservicios' },
    { host: '127.0.0.1', port: 5432, user: 'iger', database: 'keservicios' },
    { host: 'localhost', port: 5432, user: 'postgres', database: 'keservicios' },
    { host: '/tmp', port: 5432, database: 'keservicios' } // Socket connection
];

async function testConnection(config) {
    console.log(`Testing config: ${JSON.stringify(config)}`);
    const pool = new Pool(config);
    try {
        const client = await pool.connect();
        const res = await client.query('SELECT NOW()');
        console.log(`✅ Success! Connected to ${config.host || 'socket'} as ${config.user || 'default'}`);
        console.log('Time:', res.rows[0].now);
        client.release();
        await pool.end();
        return true;
    } catch (err) {
        console.log(`❌ Failed: ${err.message}`);
        return false;
    }
}

async function runTests() {
    for (const config of configs) {
        if (await testConnection(config)) break;
    }
}

runTests();
