import { defineConfig } from 'vite';
import react from '@vitejs/plugin-react';

export default defineConfig({
  plugins: [react()],
  server: {
    port: 8080,
    allowedHosts: ['kequiz.kemarketing.mx'],
    /*allowedHosts: ['kequiz.kemarketing.mx', 'localhost', '127.0.0.1'],*/
    proxy: {
      '/api': {
        /*target: 'http://localhost:8081',*/
	target: 'https://kequiz.kemarketing.mx',
        changeOrigin: true,
      },
      '/uploads': {
        target: 'http://localhost:8081',
        changeOrigin: true,
      },
      '/socket.io': {
        target: 'http://localhost:8081',
        ws: true,
      },
    },
  },
  build: {
    chunkSizeWarningLimit: 1000,
  },
});

